<?php
class logos extends CI_Controller {
	public function __construct(){
		parent::__construct();
		if($this->session->userdata('user_logged_in') != true)
		{
			$this->session->set_flashdata('response','<div class="alert alert-error">Unauthorised access. Login required.</div>');
			redirect('login');
		}
		$this->load->library('form_validation');
		$this->load->library('pagination');
	}
	function index($page=1)
	{
		$config['per_page']		= 5;
		$config['base_url'] 	= site_url('masters/logos/index/');
		$config['total_rows'] 	= $this->crud_model->get_count('logos',array());

		$offset = ($page-1) * $config['per_page'];

		$data['records'] = $this->crud_model->get('logos',
		array(),
		$config['per_page'],
		$offset
		);

		$this->pagination->initialize($config);
		$data['pagination'] = $this->pagination->create_links();

		$this->load->view('templates/header');
		$this->load->view('masters/logos/list',$data);
		$this->load->view('templates/footer');
	}
	function create()
	{
		$this->load->view('templates/header');
		$this->load->view('masters/logos/create');
		$this->load->view('templates/footer');
	}
	function edit($id)
	{
		$where=array(
				'logo_id' => $id
		);
		$records=$this->crud_model->get('logos',$where);
		if($records != false){		
		
			//true section
			$data['company_name']	= $records[0]['company_name'];
			$data['logo_filename']	= $records[0]['logo_filename'];
			$data['logo_id'] = $records[0]['logo_id'];
			$this->load->view('templates/header');
			$this->load->view('masters/logos/edit',$data);
			$this->load->view('templates/footer');

		}
		else{
			//false section
			$this->session->set_flashdata('response','<div class="alert alert-error">error</div>');
			redirect('masters/logos');
		}

	}
	function do_insert()
	{
	
		$file_error = "";
		$this->form_validation->set_rules('company_name', 'Company Name', 'required|min_length[3]|max_length[100]');
		
		$allowedExts = array("gif", "jpeg", "jpg", "png");
		$temp = explode(".", $_FILES["logo_image"]["name"]);
		$extension = end($temp);
		if ((($_FILES["logo_image"]["type"] == "image/gif")
		|| ($_FILES["logo_image"]["type"] == "image/jpeg")
		|| ($_FILES["logo_image"]["type"] == "image/jpg")
		|| ($_FILES["logo_image"]["type"] == "image/pjpeg")
		|| ($_FILES["logo_image"]["type"] == "image/x-png")
		|| ($_FILES["logo_image"]["type"] == "image/png"))
		&& ($_FILES["logo_image"]["size"] < 1000000)
		&& in_array($extension, $allowedExts)){
			if ($_FILES["logo_image"]["error"] > 0) {
				$file_error = "Invalid file1";
			}/*
		  else
			{
			echo "Upload: " . $_FILES["logo_image"]["name"] . "<br>";
			echo "Type: " . $_FILES["logo_image"]["type"] . "<br>";
			echo "Size: " . ($_FILES["logo_image"]["size"] / 1024) . " kB<br>";
			echo "Stored in: " . $_FILES["logo_image"]["tmp_name"];
			}*/
		  } else {
		  	$file_error = "Invalid file2";
		  }
		
	
		$path = FCPATH."images/logos";
		$config['upload_path'] = $path;
		$config['allowed_types'] = 'gif|jpg|png|jpeg';
		//$config['max_size'] = '1000';
        //$config['max_width']  = '500';
        //$config['max_height']  = '500';
		
		
		
		$this->load->library('upload', $config);
		
		

		if ($this->upload->do_upload('logo_image')) {
			$up_data = array('upload_data' => $this->upload->data());
		} else {
			$file_error = "File upload error.3";
		}

		$filename = $up_data["upload_data"]["file_name"];

		

		if ($this->form_validation->run() == FALSE) {
			// false section
			$this->session->set_flashdata('response','<div class="alert alert-error">'.validation_errors().'</div>',':old:');
			$this->load->view('templates/header');
			$this->load->view('masters/logos/create');
			$this->load->view('templates/footer');
		} elseif($file_error) {
			$this->session->set_flashdata('response',"<div class='alert alert-error'><ul><li>Allowed File Types : jpeg, jpg, png, gif</li></ul></div>",':old:');
			$this->load->view('templates/header');
			$this->load->view('masters/logos/create');
			$this->load->view('templates/footer');			
			
		} else {
			// true section

			$company_name=$this->input->post('company_name');
			//$logos_code=$this->input->post('logos_code');

			$data=array('company_name' => $company_name, "logo_filename" => $filename);

			$rr=$this->crud_model->insert('logos',$data);

			if($rr == false){
				// error

				$this->session->set_flashdata('response','<div class="alert alert-error">logos cannot be inserted</div>',':old:');
				$this->load->view('templates/header');
				$this->load->view('masters/logos');
				$this->load->view('templates/footer');
			}
			else
			{
				// redirect
				$this->session->set_flashdata('response','<div class="alert alert-success">Company logos added successfully</div>');
				redirect('masters/logos');

			}
		}

	}

	function do_update() {
	
		$this->form_validation->set_rules('company_name', 'Company Name', 'required|max_length[100]');
		
		
		$logos_id=$this->input->post('logo_id');
		if ($this->form_validation->run() == FALSE) {
			// false section
			$where=array("logo_id"=>$logo_id);
				
			$records=$this->crud_model->get('logos',$where);
			
			if($records != false) {
				//true section
				$data['company_name']			 = $records[0]['company_name'];
				
				$this->session->set_flashdata('response','<div class="alert alert-error">'.validation_errors().'</div>',':old:');
				$this->load->view('templates/header');
				
								
				$this->load->view('masters/logos/edit',$data);
				$this->load->view('templates/footer');

			}
			else {
				//false section
				$this->session->set_flashdata('response','<div class="alert alert-error">error</div>');
				redirect('masters/logos');
			}
		} else {// true section

			$company_name =  $this->input->post('company_name');
			$logo_id   =  $this->input->post('logo_id');

			$where=array(
				'logo_id'  => $logo_id
			);
			
			$data=array(
			  'company_name' =>$company_name
			);

			$records=$this->crud_model->update('logos',$data,$where);

			$this->session->set_flashdata('response','<div class="alert alert-success">Company logo updated</div>');
			redirect('masters/logos');

		}

	}
	function do_delete($id=0)
	{
		$where=array(
			'logo_id'=> $id
		);
		$records=$this->crud_model->get('logos',$where);
		$filename = $records[0]["logo_filename"];
		unlink(FCPATH."images/logos/".$filename);
		
		$this->crud_model->delete('logos',$where);
		$this->session->set_flashdata('response','<div class="alert alert-success">Company logo deleted</div>');
		redirect('masters/logos');
	}
	
}
