<h3>Receipts</h3>
<?php
echo $this->session->flashdata('response');
?>
<table class="furniture_receipts">
    <tr><th colspan="2">Quotation Details</th></tr>
    <tr>
        <td><span>Quotation Number </span> : <?php echo $division_code."-".$quotation_number."-".$revision_number; ?></td>
        <td><span>Net Total : </span><?php echo $currency_code. " " .number_format($quotation_net_total,3); ?></td>
        
    </tr>
    <tr>
        <td><span>Salesman : </span><?php echo $salesman_name; ?></td>
        <td><span>Advance Required : </span><?php echo $currency_code." ". number_format($advance,3) ?></td>
    </tr>
    <tr>
        <td><span>Project Name : </span><?php echo $project_name; ?></td>
        <td><span>Amount Paid : </span><?php echo $currency_code." ". number_format($amount_paid,3); ?></td>
    </tr>
    <tr>
        <td><span>Client Name : </span><?php echo $client_name; ?></td>
        <td><span>Balance : </span><?php echo $currency_code." ". number_format($balance,3); ?></td>
    </tr>
    <tr>
        <td>
        <?php echo anchor('furniture/furniture_quotations/','Back','class="btn btn-primary"');?>
        <td>
        <?php echo anchor('furniture/furniture_receipt/create/'.$quotation_id .'/new','Create a New Receipt','class="btn btn-primary"');?>
        </td>
    </tr>
</table>
<br/>
<table class="table table-bordered table-hover">
	<tr>
    	<th>Receipt Number</th>
        <th>Date</th>
        <th>Mode of Payment</th>
        <th>Amount (<?php echo $currency_code; ?>)</th>
        <th>Action</th>
    </tr>
    <?php
	if($records != false) {
		foreach($records as $record){
		if($record["receipt_status"] == 1) { ?>
        	<tr class="success">
		<?php } else {?>
			<tr class="error">
        <?php } ?>
				<td><?php echo $division_code."-".$record["receipt_number"]; ?></td>
				<td><?php echo date('M d,Y',strtotime ($record["receipt_date"])); ?></td>
				<td><?php echo $record["receipt_mode"]; ?></td>
				<td><?php echo number_format($record["receipt_amount"],3); ?></td>
				<td>
					<?php if($record['receipt_status'] == 0){?>
						<a class="icon-search iframe cboxElement" title="View Receipt"
						href="<?php echo site_url('furniture/furniture_receipt/view1/'.$record["quotation_id"].'/'.$record['receipt_number']); ?>"></a>

					<?php } if($record['receipt_status'] == 1){?>
						<a class="icon-search iframe iframe cboxElement" title="View Receipt"
						href="<?php echo site_url('furniture/furniture_receipt/view1/'.$record["quotation_id"].'/'.$record["receipt_number"]); ?>"></a>

						<a class="icon-delete" title="Cancel Receipt"
						href="<?php echo site_url('furniture/furniture_receipt/cancel/'.$record["receipt_id"].'/0/'.$record["quotation_id"]); ?>"></a>
					<?php } ?> 
				</td>
			</tr>	
		<?php } 
	} else {
	?>
    	<tr>
        	<td colspan="6">No receipts</td>
        </tr>
    
    <?php
	}
	?>
</table>
<div style='clear:both'>
Legend: <span class='alert alert-success'>Active</span> <span class='alert alert-error'>Cancelled</span> 
</div>
<br /><br /><br />
