<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Applications extends CI_Controller {

	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see https://codeigniter.com/user_guide/general/urls.html
	 */
	
	function __construct() {
		parent::__construct();

		$this->load->model('general_model');
		$this->load->library('form_validation');
		$this->load->library('session');
		$this->load->helper("url");
		$this->load->library('pagination');
		$this->load->helper('date');

		if(!isset($_SESSION['logged_in'])) {
        $this->session->set_flashdata('registerMessage','Please Login First',':old:');
        return redirect('index.php/welcome/login');
    }
		
	}
	
	public function index()
	{
		if(!isset($_SESSION['admin_logged_in'])){
			redirect(base_url());
		}

		$where = array('isDeleted' => 0);
		$data['applications'] = $this->general_model->get('mst_applications',$where);
		
		$data['loginRedirect']=base_url().'index.php/masters/applications/add';
		
		$data['currentMenu'] = 'applications';
		$data['pageType'] = 'Masters';
		$data['pageHeading'] = 'Applications';
		$data['pageTitle'] = "Applications | ".HEX_APPLICATION_NAME;
		if(($this->session->userdata('adminAccess')) == 1){
			$data['viewAdminDashboardLink'] = 1;
		}else{
			$data['loginLink'] =1;
		}
		
		$this->load->view('templates/header',$data);
		$this->load->view('masters/applications/applications',$data);
		$this->load->view('templates/footer');
	}

	
	public function add(){
		if(!isset($_SESSION['admin_logged_in'])){
			redirect(base_url());
		}

		$this->form_validation->set_rules('storeName', 'Store Name', 'required');
		$this->form_validation->set_rules('storeAddress', 'Store Address', 'required');
		$this->form_validation->set_rules('storeEmail', 'Store Email', 'required|valid_email');
		$this->form_validation->set_rules('storePhone', 'Store Phone', 'required');
		$this->form_validation->set_rules('storeContactPerson', 'Contact Person', 'required');
		$this->form_validation->set_rules('storeContactPersonNo', 'Contact Person Number', 'required');
		$this->form_validation->set_rules('applicationURL', 'Appliccation URL', 'required');
		
		if ($this->form_validation->run() == FALSE) {	
			$this->session->set_flashdata('registerMessage',validation_errors(),':old:');
			redirect(base_url().'index.php/masters/applications');
		}else{

			if($this->input->post('isOfflineDB') == 1){
				$isOfflineDB = 1;
			}else{
				$isOfflineDB = 0;
			}

			if($this->input->post('isSalesOrder') == 1){
				$isSalesOrder = 1;
			}else{
				$isSalesOrder = 0;
			}

			if($this->input->post('isSalesInvoice') == 1){
				$isSalesInvoice = 1;
			}else{
				$isSalesInvoice = 0;
			}

			if($this->input->post('isActive') == 1){
				$isActive = 1;
			}else{
				$isActive = 0;
			}

			
			$data = array(
				'storeName'		 						=>	$this->input->post('storeName'),
				'storeAddress'   					=>  $this->input->post('storeAddress'),
				'storeEmail' 							=>  $this->input->post('storeEmail'),
				'storePhone'   						=>  $this->input->post('storePhone'),
				'storeContactPerson'  		=>  $this->input->post('storeContactPerson'),
				'storeContactPersonNo'  	=>  $this->input->post('storeContactPersonNo'),
				'applicationURL'  				=>  $this->input->post('applicationURL'),
				'subscriptionExpiryDate'  =>  date('Y-m-d', strtotime($this->input->post('subscriptionExpiryDate'))),
				'isOfflineDB'  						=>  $isOfflineDB,
				'isSalesOrder'  					=>  $isSalesOrder,
				'isSalesInvoice'  				=>  $isSalesInvoice,
				'isActive'      					=>  $isActive
			);
			$this->general_model->insert('mst_applications',$data);
			$this->session->set_flashdata('registerMessage','Application Added Successfully',':old:');
			redirect(base_url().'index.php/masters/applications');
		}
	}

	public function edit($appID=0){
		if(!isset($_SESSION['admin_logged_in'])){
			redirect(base_url());
		}
		
		$where = array('isDeleted' => 0);
		$whereEdit = array('appID' => $appID);

		$data['applications'] = $this->general_model->get('mst_applications',$where);
		$data['singleapplications'] =$this->general_model->get('mst_applications',$whereEdit);

		$data['loginRedirect']=base_url().'index.php/masters/applications/update';
		
		$data['currentMenu'] = 'applications';
		$data['pageType'] = 'Masters';
		$data['pageHeading'] = 'Applications';
		$data['pageTitle'] = "Applications | ".HEX_APPLICATION_NAME;

		$this->load->view('templates/header',$data);
		$this->load->view('masters/applications/editApplication',$data);
		$this->load->view('templates/footer');
	}

	public function update(){
		if(!isset($_SESSION['admin_logged_in'])){
			redirect(base_url());
		}
		$this->form_validation->set_rules('storeName', 'Store Name', 'required');
		$this->form_validation->set_rules('storeAddress', 'Store Address', 'required');
		$this->form_validation->set_rules('storeEmail', 'Store Email', 'required|valid_email');
		$this->form_validation->set_rules('storePhone', 'Store Phone', 'required');
		$this->form_validation->set_rules('storeContactPerson', 'Contact Person', 'required');
		$this->form_validation->set_rules('storeContactPersonNo', 'Contact Person Number', 'required');
		
		if ($this->form_validation->run() == FALSE) {	
			$this->session->set_flashdata('registerMessage',validation_errors(),':old:');
			redirect(base_url().'index.php/masters/applications');
		}else{
			//print_r($_POST); exit;
			$isOfflineDB = 0;
			$isSalesOrder = 0;
			$isSalesInvoice = 0;
			if($this->input->post('isOfflineDB') == "1"){
				$isOfflineDB = 1;
			}else{
				$isOfflineDB = 0;
			}

			if($this->input->post('isSalesOrder') == "1"){
				$isSalesOrder = 1;
			}else{
				$isSalesOrder = 0;
			}

			if($this->input->post('isSalesInvoice') == "1"){
				$isSalesInvoice = 1;
			}else{
				$isSalesInvoice = 0;
			}


			$data = array(
				'storeName'		 						=>	$this->input->post('storeName'),
				'storeAddress'   					=>  $this->input->post('storeAddress'),
				'storeEmail' 							=>  $this->input->post('storeEmail'),
				'storePhone'   						=>  $this->input->post('storePhone'),
				'storeContactPerson'  		=>  $this->input->post('storeContactPerson'),
				'storeContactPersonNo'  	=>  $this->input->post('storeContactPersonNo'),
				'subscriptionExpiryDate'  =>  date('Y-m-d', strtotime($this->input->post('subscriptionExpiryDate'))),
				'isOfflineDB'  						=>  $isOfflineDB,
				'isSalesOrder'  					=>  $isSalesOrder,
				'isSalesInvoice'  				=>  $isSalesInvoice
			);
			$where = array(
				'appID'					=> $this->input->post('appID')
			);
			$this->general_model->update('mst_applications',$data,$where);
			$this->session->set_flashdata('registerMessage','Application Upddated Successfully',':old:');
			redirect(base_url().'index.php/masters/applications');
		}
	}

	public function makeActive($appID = 0){
		if(!isset($_SESSION['admin_logged_in'])){
			redirect(base_url());
		}
		$data = array(
				'isActive'		 		=>	1
		);
			
		$where = array(
			'appID'					=> $appID
		);
		$this->general_model->update('mst_applications',$data,$where);
		$this->session->set_flashdata('registerMessage','Application Activated Successfully',':old:');
		redirect(base_url().'index.php/masters/applications');
	}

	public function makeInactive($appID = 0){
		if(!isset($_SESSION['admin_logged_in'])){
			redirect(base_url());
		}
		$data = array(
				'isActive'		 		=>	0
		);
			
		$where = array(
			'appID'					=> $appID
		);
		$this->general_model->update('mst_applications',$data,$where);
		$this->session->set_flashdata('registerMessage','Application Deactivated Successfully',':old:');
		redirect(base_url().'index.php/masters/applications');
	}

	public function delete($itemID=0){
		if(!isset($_SESSION['admin_logged_in'])){
			redirect(base_url());
		}
		$data = array(
			'isDeleted'		=>	1
		);
		$where = array('appID' => $appID);
		$this->general_model->update('mst_applications',$data, $where);
		$this->session->set_flashdata('registerMessage','Application Deleted Successfully',':old:');
		redirect(base_url().'index.php/masters/applications');
	}
}
