<?php 
class General_Model extends CI_Model {
	public function __construct() {
		$this->load->database();
		//$this->load->library('encrypt');
		$this->load->helper("date");
	}
	
	// select records
	function get($table_name = '', $where=array(),$limit=null,$offset=null,$order_by_field=null,$order_by_order=null,$like=null, $or_where=null, $whereField = NULL ,$where_in = NULL){
		if(!is_null($offset) and !is_null($limit)){
			$this->db->limit($limit,$offset);
		}
		if($order_by_field != null and $order_by_order != null){
			$this->db->order_by($order_by_field, $order_by_order);
		}
		
		if($like !=null && is_array($like)) {
			foreach($like as $key=>$value) {			
				$this->db->like($key, $value); 
			}
		}
		
		if($or_where) {
			$this->db->or_where($or_where);
		}

		if(! empty($where_in))
     {
       $this->db->where_in($whereField ,$where_in);
     }
		
		$rs = $this->db->get_where($table_name, $where);
		if($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;
		}
	}
	
	function getCount($table_name = '', $where=array(),$limit=null,$offset=null,$order_by_field=null,$order_by_order=null,$like=null, $or_where=null){
		if(!is_null($offset) and !is_null($limit)){
			$this->db->limit($limit,$offset);
		}
		if($order_by_field != null and $order_by_order != null){
			$this->db->order_by($order_by_field, $order_by_order);
		}
		
		if($like !=null && is_array($like)) {
			foreach($like as $key=>$value) {			
				$this->db->like($key, $value); 
			}
		}
		
		if($or_where) {
			$this->db->or_where($or_where);
		}
		
		$rs = $this->db->get_where($table_name, $where);
		return $rs->num_rows();
	}

	function getSum($field_name = '', $table_name = '', $where=array(),$limit=null,$offset=null,$order_by_field=null,$order_by_order=null,$like=null, $or_where=null){
		if(!is_null($offset) and !is_null($limit)){
			$this->db->limit($limit,$offset);
		}
		if($order_by_field != null and $order_by_order != null){
			$this->db->order_by($order_by_field, $order_by_order);
		}
		
		if($like !=null && is_array($like)) {
			foreach($like as $key=>$value) {			
				$this->db->like($key, $value); 
			}
		}

		$this->db->select_sum($field_name);
		
		if($or_where) {
			$this->db->or_where($or_where);
		}
		
		$rs = $this->db->get_where($table_name, $where);
		if($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;
		}
	}


	
	// get list of records for drop down
	function get_list($id_field_name,$value_field_name,$table_name,$init_list=array(),$where=array()){
		$this->db->select($id_field_name);
		$this->db->select($value_field_name);
		$this->db->where($where);
		$rs = $this->db->get($table_name);
		if($rs->num_rows()>0){
			$records = $rs->result_array();
			foreach($records as $record){
				$init_list[$record[$id_field_name]] = $record[$value_field_name];
			}
			
			return $init_list;
		}
		else{
			return array();
		}
	}

	
	
	// get list of records for drop down
	function get_users_list($id_field_name,$value_field_name1,$value_field_name2,$table_name,$init_list=array(),$where=array()){
		$this->db->select($id_field_name);
		$this->db->select($value_field_name1);
		$this->db->select($value_field_name2);
		$this->db->where($where);
		$rs = $this->db->get($table_name);
		if($rs->num_rows()>0){
			$records = $rs->result_array();
			foreach($records as $record){
				$init_list[$record[$id_field_name]] = $record[$value_field_name1].' '.$record[$value_field_name2];
			}
			return $init_list;
		}
		else{
			return array();
		}
	}
	
	// create new record
	function insert($table_name = '', $data=array()){
		$this->db->insert($table_name,$data);
		return $this->db->insert_id();
	}	

	// insert batch of records
	function insert_batch($table_name = '', $data=array()){
		$this->db->insert_batch($table_name,$data);
	}
	
	// update existing record
	function update($table_name = '', $data=array(),$where=array()){
		$this->db->update($table_name,$data,$where);
	}


	
	// delete existing record
	function delete($table_name = '', $where=array(), $multiple=false){
		if($multiple) {
			$this->db->where_in($where["key"], $where["value"]);
			$this->db->delete($table_name);
		} else {
			$this->db->delete($table_name,$where);
		}
	}
	
	
	// Check Teacher Login
	function check_admin_login($username='',$userPassword='')
	{
		$where = array(
			'userLogin' 		=> $username,
			'userPassword' 	=> md5($userPassword),
			'userType' 			=> 1,
			'isActive'			=> 1
		);
		

		$records = $this->get('mst_users',$where);
		
		if($records != false)
		{//if email id and password available in db return true
			return $records[0];
		}
		else
		{// else return false
			return false;
		}
	}
	

	
	
	public function checkPassword($userId=0, $password=''){
		$where = array(
			'userId' => $userId,
			'userPassword' => md5($password)
		);
		$records = $this->get('users',$where);
		
		if($records != false)
		{//if email id and password available in db return true
			return $records[0];
		}
		else
		{// else return false
			return false;
		}
	}
	
	public function randomPassword() {
    	$alphabet = "abcdefghijklmnopqrstuwxyzABCDEFGHIJKLMNOPQRSTUWXYZ0123456789";
    	$pass = array(); //remember to declare $pass as an array
		$alphaLength = strlen($alphabet) - 1; //put the length -1 in cache
		for ($i = 0; $i < 8; $i++) {
			$n = rand(0, $alphaLength);
			$pass[] = $alphabet[$n];
		}
		return implode($pass); //turn the array into a string
	}
	
	function get_sm_products($where=array(),$limit=null,$offset=null,$order_by_field=null,$order_by_order=null,$like=null, $or_where=null){
		if(!is_null($offset) and !is_null($limit)){
			$this->db->limit($limit,$offset);
		}
		if($order_by_field != null and $order_by_order != null){
			$this->db->order_by($order_by_field, $order_by_order);
		}
		
		if($like !=null && is_array($like)) {
			foreach($like as $key=>$value) {			
				$this->db->like($key, $value); 
			}
		}
		
		if($or_where) {
			$this->db->or_where($or_where);
		}

		$this->db->select('mst_items.tax_rate as productTax, mst_items.*');
		$this->db->select('mst_godown.*');
		$this->db->select('mst_item_details.*');
		
		$this->db->join('mst_godown', 'trn_godown_stock.godown = mst_godown.godownID', 'left');	
		$this->db->join('mst_item_details', 'trn_godown_stock.item = mst_item_details.item_details_id', 'left');
		$this->db->join('mst_items', 'mst_item_details.item_code = mst_items.item_code', 'left');

		$rs = $this->db->get_where('trn_godown_stock', $where);
		if($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;
		}
	}

	function get_products($where=array(),$limit=null,$offset=null,$order_by_field=null,$order_by_order=null,$like=null, $or_where=null){
		if(!is_null($offset) and !is_null($limit)){
			$this->db->limit($limit,$offset);
		}
		if($order_by_field != null and $order_by_order != null){
			$this->db->order_by($order_by_field, $order_by_order);
		}
		
		if($like !=null && is_array($like)) {
			foreach($like as $key=>$value) {			
				$this->db->like($key, $value); 
			}
		}
		
		if($or_where) {
			$this->db->or_where($or_where);
		}

		$this->db->select('mst_items.tax_rate as productTax, mst_items.*');
		$this->db->select('mst_item_details.*');
		
		$this->db->join('mst_items', 'mst_item_details.item_code = mst_items.item_code', 'left');

		$rs = $this->db->get_where('mst_item_details', $where);
		if($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;
		}
	}

	function get_invoices($where=array(),$limit=null,$offset=null,$order_by_field=null,$order_by_order=null,$like=null, $or_where=null){
		if(!is_null($offset) and !is_null($limit)){
			$this->db->limit($limit,$offset);
		}
		if($order_by_field != null and $order_by_order != null){
			$this->db->order_by($order_by_field, $order_by_order);
		}
		
		if($like !=null && is_array($like)) {
			foreach($like as $key=>$value) {			
				$this->db->like($key, $value); 
			}
		}
		
		if($or_where) {
			$this->db->or_where($or_where);
		}

		
		$this->db->join('mst_customers', 'trn_sales_invoice.customer = mst_customers.client_id', 'left');

		$rs = $this->db->get_where('trn_sales_invoice', $where);
		if($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;
		}
	}


	public function getmax($field_name,$table_name){
		
		$this->db->select_max($field_name);
		$res1 = $this->db->get($table_name);
		if ($res1->num_rows() > 0) {
			$res2 = $res1->result_array();        			
		}
		$max = $res2[0][$field_name];
		if($max == NULL) return 1000; else return $max+1;
	}
	
	








} 