<?php
	if(isset($_SESSION['admin_logged_in'])|| in_array("ItemCreate",$_SESSION['assignedPermissions'])){
?>
<div class="row">
	<div class="col-md-12 col-lg-12">
		<div class="card">
			<div class="card-header">
				<h3 class="card-title"><?php echo "Add New ".$pageHeading;?></h3>
			</div>
			<div class="card-body">
				<?php 
          $attributes = array('class' => 'form form-horizontal form-bordered', 'id' => 'form');
          echo form_open_multipart($loginRedirect,$attributes);
        ?>
				<div class="row">
					<div class="col-md-4">
						<div class="form-group">
							<label class="form-label">Item Code</label>
							<input type="text" class="form-control" name="itemCode" placeholder="Item Code">
						</div>
					</div>
					<div class="col-md-4">
						<div class="form-group">
							<label class="form-label">Item Name</label>
							<input type="text" class="form-control" name="itemName" placeholder="Item Name">
						</div>
					</div>
					<div class="col-md-4">
						<div class="form-group">
							<label class="form-label">Item Unit</label>
							<input type="text" class="form-control" name="itemUnit" placeholder="Item Unit">
						</div>
					</div>
					<div class="col-md-4">
						<div class="form-group">
							<label class="form-label">Item Desccription</label>
							<textarea class="form-control" name="itemDescription" rows="4" placeholder="Item Description"></textarea>
						</div>
					</div>
					<div class="col-md-4">
						<div class="form-group">
							<label class="form-label">Item Tax</label>
							<?php 
                $designationsOptionsJs = 'id="itemTax" class="form-control  itemTax"';
                echo form_dropdown('itemTax', $tax, '',$designationsOptionsJs);
              ?>
						</div>
					</div>
					<div class="col-md-4">
						<div class="form-group">
							<label class="form-label">Item Cost</label>
							<input type="number" step="0.001" class="form-control" name="itemCost" placeholder="Item Cost">
						</div>
					</div>
					<div class="col-md-4">
						<div class="form-group">
							<div class="form-label"></div>
							<input type="submit" class="btn btn-primary" name="" value="Submit">
						</div>
					</div>
				</div>
				<?php echo form_close();?>
				<?php if($this->session->flashdata('registerMessage')){ ?>
          <div class="alert alert-warning ">
            <a class="panel-close close " data-dismiss="alert">×</a> 
            <i class="fa fa-coffe"></i>
            <?php echo $this->session->flashdata('registerMessage');?>
          </div>
        <?php } ?>
			</div>
		</div>
	</div>
</div>
<!-- ROW-1 : Add New Items -->
<?php
	}
?>

<div class="row">
	<div class="col-md-12 col-lg-12">
		<div class="card">
			<div class="card-header">
				<h3 class="card-title"><?php echo $pageHeading;?></h3>
			</div>
			<div class="card-body">
				<div class="table-responsive">
					<table id="example" class="table table-striped table-bordered text-nowrap w-100">
						<thead>
							<tr>
								<th class="wd-15p">Item Code</th>
								<th class="wd-15p">Item Name</th>
								<th class="wd-20p">Item Unit</th>
								<th class="wd-15p">Cost</th>
								<th class="wd-10p">Status</th>
								<?php 
									if(isset($_SESSION['admin_logged_in'])|| in_array("ItemEdit",$_SESSION['assignedPermissions'])){
								?>
									<th class="wd-25p">Actions</th>
								<?php } ?>
							</tr>
						</thead>
						<tbody>
							<?php
								if(is_array($items)){
									foreach($items as $item){
							?>
										<tr>
											<td><?php echo $item['itemCode'];?></td>
											<td><?php echo $item['itemName'];?></td>
											<td><?php echo $item['itemUnit'];?></td>
											<td><?php echo $item['itemCost'];?></td>
											<td>
												<?php 
													if($item['isActive'] == 1){
														echo "Active";
													}else{
														echo "Inactive";
													}
												?>
											</td>
											<?php 
												if(isset($_SESSION['admin_logged_in'])|| in_array("ItemEdit",$_SESSION['assignedPermissions'])){
											?>
											<td>
												<?php 
													if($item['isActive'] == 1){
												?>
														<a class="btn" href="<?php echo base_url()?>index.php/masters/items/makeInactive/<?php echo $item['itemID'];?>">
															<i class="icon icon-control-pause" data-toggle="tooltip" title="Make Inactive"></i>
														</a>
												<?php
													}else{
												?>
														<a class="btn" href="<?php echo base_url()?>index.php/masters/items/makeActive/<?php echo $item['itemID'];?>">
															<i class="icon icon-control-play" data-toggle="tooltip" title="Make Active"></i>
														</a>
												<?php
													}
												?>
												<a class="btn" href="<?php echo base_url()?>index.php/masters/items/edit/<?php echo $item['itemID'];?>">
													<i class="icon icon-note" data-toggle="tooltip" title="Edit"></i>
												</a>
												<a class="btn" href="<?php echo base_url()?>index.php/masters/items/delete/<?php echo $item['itemID'];?>">
													<i class="icon icon-trash" data-toggle="tooltip" title="Delete"></i>
												</a>
											</td>
											<?php 
												}
											?>
										</tr>
							<?php
									}
								}
							?>
						</tbody>
					</table>
				</div>
				<!-- table-responsive -->
			</div>
		</div>
	</div>
</div>
