<?php
	if(isset($_SESSION['admin_logged_in'])|| in_array("ProjectCreate",$_SESSION['assignedPermissions'])){
?>
<div class="row">
	<div class="col-md-12 col-lg-12">
		<div class="card">
			<div class="card-header">
				<h3 class="card-title"><?php echo "Add New ".$pageHeading;?></h3>
			</div>
			<div class="card-body">
				<?php 
          $attributes = array('class' => 'form form-horizontal form-bordered', 'id' => 'form');
          echo form_open_multipart($loginRedirect,$attributes);
        ?>
				<div class="row">
					<div class="col-md-4">
						<div class="form-group">
							<label class="form-label">Supplier Code</label>
							<input type="text" class="form-control" name="supplierCode" placeholder="Supplier Code" required="required">
						</div>
					</div>
					<div class="col-md-4">
						<div class="form-group">
							<label class="form-label">Supplier Name</label>
							<input type="text" class="form-control" name="supplierName" placeholder="Supplier Name" required="required">
						</div>
					</div>
					<div class="col-md-4">
						<div class="form-group">
							<label class="form-label">Contact Person</label>
							<input type="text" class="form-control" name="SupplierContactPerson" placeholder="Contact Person" required="required">
						</div>
					</div>
					<div class="col-md-4">
						<div class="form-group">
							<label class="form-label">Phone Number</label>
							<input type="text" class="form-control" name="supplierPhone" placeholder="Phone Number" required="required">
						</div>
					</div>
					<div class="col-md-4">
						<div class="form-group">
							<label class="form-label">Email Address</label>
							<input type="text" class="form-control" name="supplierEmail" placeholder="Email Address" required="required">
						</div>
					</div>
					<div class="col-md-4">
						<div class="form-group">
							<label class="form-label">Fax</label>
							<input type="text" class="form-control" name="supplierFax" placeholder="Fax">
						</div>
					</div>
					<div class="col-md-4">
						<div class="form-group">
							<label class="form-label">Address Line 1</label>
							<input type="text" class="form-control" name="supplierAddress1" placeholder="Address" required="required">
						</div>
					</div>
					<div class="col-md-4">
						<div class="form-group">
							<label class="form-label">Address Line 2</label>
							<input type="text" class="form-control" name="supplierAddress2" placeholder="Address">
						</div>
					</div>
					<div class="col-md-4">
						<div class="form-group">
							<label class="form-label">TRN</label>
							<input type="text" class="form-control" name="supplierTRN" placeholder="TRN">
						</div>
					</div>
					<div class="col-md-4">
						<div class="form-group">
							<div class="form-label"></div>
							<input type="submit" class="btn btn-primary" name="" value="Submit">
						</div>
					</div>
				</div>
				<?php echo form_close();?>
				<?php if($this->session->flashdata('registerMessage')){ ?>
          <div class="alert alert-warning ">
            <a class="panel-close close " data-dismiss="alert">×</a> 
            <i class="fa fa-coffe"></i>
            <?php echo $this->session->flashdata('registerMessage');?>
          </div>
        <?php } ?>
			</div>
		</div>
	</div>
</div>
<?php
	}
?>
<!-- ROW-1 : Add New Items -->
<div class="row">
	<div class="col-md-12 col-lg-12">
		<div class="card">
			<div class="card-header">
				<h3 class="card-title"><?php echo $pageHeading;?></h3>
			</div>
			<div class="card-body">
				<div class="table-responsive">
					<table id="example" class="table table-striped table-bordered text-nowrap w-100">
						<thead>
							<tr>
								<th class="wd-15p">Supplier Code</th>
								<th class="wd-15p">Supplier Name</th>
								<th class="wd-20p">Contact Person</th>
								<th class="wd-15p">Phone</th>
								<th class="wd-15p">Email</th>
								<th class="wd-15p">Fax</th>
								<th class="wd-10p">Status</th>
								<?php 
									if(isset($_SESSION['admin_logged_in'])|| in_array("SupplierEdit",$_SESSION['assignedPermissions'])){
								?>
									<th class="wd-25p">Actions</th>
								<?php } ?>
							</tr>
						</thead>
						<tbody>
							<?php
								if(is_array($suppliers)){
									foreach($suppliers as $supplier){
							?>
										<tr>
											<td><?php echo $supplier['supplierCode'];?></td>
											<td><?php echo $supplier['supplierName'];?></td>
											<td><?php echo $supplier['SupplierContactPerson'];?></td>
											<td><?php echo $supplier['supplierPhone'];?></td>
											<td><?php echo $supplier['supplierEmail'];?></td>
											<td><?php echo $supplier['supplierFax'];?></td>
											<td>
												<?php 
													if($supplier['isActive'] == 1){
														echo "Active";
													}else{
														echo "Inactive";
													}
												?>
											</td>
											<?php 
												if(isset($_SESSION['admin_logged_in'])|| in_array("SupplierEdit",$_SESSION['assignedPermissions'])){
											?>
											<td>
												<?php 
													if($supplier['isActive'] == 1){
												?>
														<a class="btn" href="<?php echo base_url()?>index.php/masters/suppliers/makeInactive/<?php echo $supplier['supplierID'];?>">
															<i class="icon icon-control-pause" data-toggle="tooltip" title="Make Inactive"></i>
														</a>
												<?php
													}else{
												?>
														<a class="btn" href="<?php echo base_url()?>index.php/masters/suppliers/makeActive/<?php echo $supplier['supplierID'];?>">
															<i class="icon icon-control-play" data-toggle="tooltip" title="Make Active"></i>
														</a>
												<?php
													}
												?>
												<a class="btn" href="<?php echo base_url()?>index.php/masters/suppliers/edit/<?php echo $supplier['supplierID'];?>">
													<i class="icon icon-note" data-toggle="tooltip" title="Edit"></i>
												</a>
												<a class="btn" href="<?php echo base_url()?>index.php/masters/suppliers/delete/<?php echo $supplier['supplierID'];?>">
													<i class="icon icon-trash" data-toggle="tooltip" title="Delete"></i>
												</a>
											</td>
											<?php } ?>
										</tr>
							<?php
									}
								}
							?>
						</tbody>
					</table>
				</div>
				<!-- table-responsive -->
			</div>
		</div>
	</div>
</div>
