<div class="row">
	<div class="col-md-12 col-lg-12">
		<div class="card">
			<div class="card-header">
				<h3 class="card-title"><?php echo "Add New ".$pageHeading;?></h3>
			</div>
			<div class="card-body">
				<?php 
          $attributes = array('class' => 'form form-horizontal form-bordered', 'id' => 'form');
          echo form_open_multipart($loginRedirect,$attributes);
        ?>
				<div class="row">
					<div class="col-md-4">
						<div class="form-group">
							<label class="form-label">Department</label>
							<?php 
                $designationsOptionsJs = 'id="department" class="form-control  department" required';
                echo form_dropdown('department', $departments, '',$designationsOptionsJs);
              ?>
						</div>
					</div>
					<div class="col-md-2">

					</div>
					<div class="col-md-3">
						<div class="form-group">
							<label class="form-label">MRN #</label>
							<input type="text" class="form-control" name="mrnNo" value="<?php echo $mrnNo;?>" placeholder="MRN #" readonly="readonly">
						</div>
					</div>
					<div class="col-md-3">
						<div class="form-group">
							<label class="form-label">Date</label>
							<input type="text" class="form-control hex-datepicker" name="materialRequestDate" placeholder="DD/MM/YYYY">
						</div>
					</div>
					<div class="col-md-4">
						<div class="form-group">
							<label class="form-label">Project</label>
							<div class="projectsOuter">
								<?php 
	                $designationsOptionsJs = 'id="project" class="form-control  project"';
	                echo form_dropdown('project', $projects, '',$designationsOptionsJs);
	              ?>
	            </div>
						</div>
					</div>
					<div class="col-md-8">
						<div class="form-group">
							<label class="form-label">Supplier</label>
							<?php 
                $designationsOptionsJs = 'id="supplier" class="form-control  supplier" required';
                echo form_dropdown('supplier', $suppliers, '',$designationsOptionsJs);
              ?>
						</div>
					</div>
					<div class="col-md-4">
						<div class="form-group">
							<label class="form-label">Delivery Location</label>
							<?php 
                $designationsOptionsJs = 'id="deliveryLocation" class="form-control  deliveryLocation" required';
                echo form_dropdown('deliveryLocation', $locations, '',$designationsOptionsJs);
              ?>
						</div>
					</div>
					<div class="col-md-8">
						<div class="form-group">
							<label class="form-label">Narration</label>
							<input type="text" class="form-control" name="narration" placeholder="Narration">
						</div>
					</div>

					<!-- <div class="col-md-4">
						<div class="form-group">
							<div class="form-label"></div>
							<input type="submit" class="btn btn-primary" name="" value="Submit">
						</div>
					</div> -->
				</div>
				<div class="row">
					<div class="table-responsive">
						<table id="materialRequestTable" class="table table-striped table-bordered text-nowrap w-100">
							<thead>
								<tr>
									<th class="wd-10p">Item Type</th>
									<th class="wd-15p">Item</th>
									<th class="wd-15p">Item Description</th>
									<th class="wd-15p">Brand</th>
									<th class="wd-15p">Packing</th>
									<th class="wd-10p">Qty</th>
									<th class="wd-10p">Supplier</th>
									<th class="wd-10p">+</th>
								</tr>
							</thead>
							<tbody>
								<tr class="contentRow">
									<td>
										<?php 
			                $designationsOptionsJs = 'id="" class="form-control  itemType"';
			                $itemTypes = array('master' => 'Item Master', 'custom' => 'Custom');
			                echo form_dropdown('itemType[]', $itemTypes, '',$designationsOptionsJs);
			              ?>
									</td>
									<td>
										<?php 
			                $designationsOptionsJs = 'class="form-control itemList"';
			                echo form_dropdown('itemID[]', $items, '',$designationsOptionsJs);
			              ?>
									</td>
									<td>
										<input type="text" class="form-control customItem" name="item[]" placeholder="item">
									</td>
									<td>
										<input type="text" class="form-control" name="brand[]" placeholder="Brand">
									</td>
									<td>
										<input type="text" class="form-control" name="packing[]" placeholder="Packing">
									</td>
									<td>
										<input type="text" class="form-control" name="qty[]" placeholder="Qty">
									</td>
									<td>
										<?php 
			                $designationsOptionsJs = 'class="form-control  supplier"';
			                echo form_dropdown('itemsupplier[]', $suppliers, '',$designationsOptionsJs);
			              ?>
									</td>
									<td>
										<!-- <button type="button" class="btn btn-primary addItem"> + </button> -->
										<a class="btn btn-primary addItem"> + </a> 
									</td>
								</tr>
							</tbody>
						</table>
					</div>
					<div class="col-md-4">
						<div class="form-group">
							<div class="form-label"></div>
							<input type="submit" class="btn btn-primary" name="" value="Submit">
						</div>
					</div>
				</div>
				<?php echo form_close();?>
				<?php if($this->session->flashdata('registerMessage')){ ?>
          <div class="alert alert-warning ">
            <a class="panel-close close " data-dismiss="alert">×</a> 
            <i class="fa fa-coffe"></i>
            <?php echo $this->session->flashdata('registerMessage');?>
          </div>
        <?php } ?>
			</div>
		</div>
	</div>
</div>
<!-- ROW-1 : Add New Items -->

<script type="text/javascript">
	$(document).ready(function(){
		$('.department').change(function(){
			var department = $(this).val();
			$.ajax({
				type: "POST",
				url: "<?php echo base_url()?>index.php/transactions/PurchaseOrders/getPrjFromDept/",
				data: {department:department},
				success: function (data) {
					//alert(data);
					$('.projectsOuter').html(data);
				},
				error: function () {
					alert("Server Error! Please try again later.");
				}
			});
		});

		$(document).on('change', '.itemType', function(){
			var itemType = $(this).val();
			if(itemType == "master"){
				$(this).parents('tr').find('.customItem').attr('readonly', true);
				$(this).parents('tr').find('.itemList').show();
			}else{
				$(this).parents('tr').find('.customItem').val('');
				$(this).parents('tr').find('.itemList').prop('selectedIndex',0);
				$(this).parents('tr').find('.customItem').attr('readonly', false);
				$(this).parents('tr').find('.itemList').hide();
			}
		});

		$(document).on('change', '.itemList', function(){
			var itemID = $(this).val();
			$item = $(this);
			$.ajax({
				type: "POST",
				url: "<?php echo base_url()?>index.php/transactions/MaterialRequest/getItemDesc/",
				data: {itemID:itemID},
				success: function (data) {
					$item.parents('tr').find('.customItem').val(data);
				},
				error: function () {
					alert("Server Error! Please try again later.");
				}
			});
		});

		var table = $('#materialRequestTable')[0];

		$('#materialRequestTable').on('click', '.addItem', function(){
		//$('.addItem').click(function(){
			//debugger;
			var thisRow = $(this).closest( 'tr' )[0];
			$( thisRow ).clone().insertAfter( thisRow ).find( 'input:text' ).val( '' );
		});
	});
</script>
